//
//  TTTBoard.h
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 9/3/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import <UIKit/UIKit.h>

@class TTTGameGrid;
@class TTTGameSessionViewController;

@interface TTTBoard : UIView{
    @private BOOL enabled;
    @private TTTGameSessionViewController *gameSession;
    @private TTTGameGrid *grid;
    @private float width;         // width of one block
    @private float height;       // will be same as width;
}
    - (void) setGrid: (TTTGameGrid *) aGrid;
    - (void) setGameSession: (TTTGameSessionViewController *) aGameSession;
    - (float) getWidth;
    - (float) getHeight;
    - (void) invalidateBlock: (int) x :(int) y;
    - (BOOL) isInputEnabled;
    - (void) disableInput;
    - (void) enableInput;

@end
